<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use VM\ApiBundle\Entity\CreatorStages;
use VM\ApiBundle\Entity\CreatorStagesParts;
use VM\ApiBundle\Entity\CreatorStagesSteps;
use VM\ApiBundle\Entity\UserCompanyRoleTypes;


class LoadUserCompanyRoleTypes extends AbstractFixture implements OrderedFixtureInterface
{
    private $roleTypes = array(
        array(
            'symbol' => 'M',
            'description' => 'Członek zarządu'
        ),
        array(
            'symbol' => 'C',
            'description' => 'Prezes'
        ),
    );

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        foreach($this->roleTypes as $roleType)
        {
            $UserCompanyRoleType = new UserCompanyRoleTypes();

            $UserCompanyRoleType->setSymbol($roleType['symbol']);
            $UserCompanyRoleType->setDescription($roleType['description']);

            $EntityManager->persist($UserCompanyRoleType);
        }

        $EntityManager->flush();
    }

    public function getOrder()
    {
        return 20;
    }
}